#pragma GCC optimize("O3")
#ifdef LOCAL

#   include <debug.h>

#else
#   include <bits/stdc++.h>
#   include <ext/pb_ds/assoc_container.hpp>
#   define debug(...)
#endif
using namespace std;

struct Point {
    long long x = 0, y = 0;

    Point() = default;

    Point(int x, int y) : x(x), y(y) {}

    Point(const Point &A, const Point &B) {
        x = B.x - A.x;
        y = B.y - A.y;
    }
};

long long operator%(const Point &A, const Point &B) {
    return A.x * B.y - A.y * B.x;
}

long long operator*(const Point &A, const Point &B) {
    return A.x * B.x + A.y * B.y;
}

istream &operator>>(istream &in, Point &P) {
    return in >> P.x >> P.y;
}

bool point_and_ray(const Point &O, const Point &A, const Point &B) {
    Point AB(A, B);
    Point AO(A, O);
    return AB % AO == 0 && AB * AO >= 0;
}

bool ray_and_ray(const Point &A, const Point &B, const Point &C, const Point &D) {
    if (point_and_ray(C, A, B) || point_and_ray(A, C, D)) {
        return true;
    }
    Point AB(A, B);
    Point CD(C, D);
    Point AC(A, C);
    Point CA(C, A);
    if (AB % CD == 0) {
        return false;
    }
    if (AB % AC > 0) {
        return CA % CD > 0 && CD % AB > 0;
    } else {
        return CD % CA > 0 && AB % CD > 0;
    }
}

bool check(const Point &A, const Point &B, const Point &C, const Point &D) {
    return ray_and_ray(A, B, C, D) &&
           ray_and_ray(B, A, C, D) &&
           ray_and_ray(A, B, D, C) &&
           ray_and_ray(B, A, D, C);
}

namespace dsu {
    static const int size = 4000 * 4000;
    int p[size];
    int sz[size];
    int cnt = 0;

    void init(int n) {
        iota(p, p + n * n, 0);
        fill(sz, sz + n * n, 1);
        cnt = 0;
    }

    int get(int u) {
        if (u == p[u]) {
            return u;
        } else {
            return p[u] = get(p[u]);
        }
    }

    void join(int u, int v) {
        u = get(u);
        v = get(v);
        if (u == v) return;
        cnt++;

        if (sz[u] < sz[v]) {
            swap(u, v);
        }
        p[v] = u;
        sz[u] += sz[v];
    }
}

void solve() {
    int n;
    cin >> n;
    vector<pair<Point, Point>> S(n);
    for (auto &[A, B]: S) {
        cin >> A >> B;
    }

    int e = 0;

    dsu::init(n);

    vector<int> Q;
    Q.reserve(n);
    for (int i = 0; i < n; i++) {
        Q.resize(0);
        for (int j = 0; j < n; j++) {
            const auto &[A, B] = S[i];
            const auto &[C, D] = S[j];
            if (i != j && check(A, B, C, D)) {
                Q.push_back(j);
            }
        }
        for (auto &j: Q) {
            if (j < i) {
                j = j * n + i;
            } else {
                j = i * n + j;
            }
        }
        for (int j = 1; j < (int) Q.size(); j++) {
            e += 1;
            dsu::join(Q[j - 1], Q[j]);
        }
    }
    cout << e - dsu::cnt + 1 << "\n";
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int t;
    cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}